#ifndef _OBJECTPROPERTY_DESC_H_
#define _OBJECTPROPERTY_DESC_H_

#include <Client/ClientUtils/Network/TableAttributeDesc.h>
#include <Geometry/SimplexProperty.h>
#include <Geometry/boost_serialize_includes.hpp>
#include <buildspec.h>

#include <map>
#include <string>

#include <boost/shared_ptr.hpp>

namespace GST
{
namespace ClientUtils
{

class GST_API_EXPORT ObjectPropertyDesc : public TableAttributeDesc
{
	friend class boost::serialization::access;

public:
	/// default c'tor
	ObjectPropertyDesc();
	/// Creation c'tor
	ObjectPropertyDesc(const TableAttributeDesc &parent);
	ObjectPropertyDesc(const std::string &name,
					   const std::string &tablename,
					   DType type,
					   int dimension,
					   bool notNull,
					   const std::string &alternativeType = "",
					   const int &colIndex = -1,
					   const long &id = -1);
	/// copy c'tor
	ObjectPropertyDesc(const ObjectPropertyDesc &other);

	~ObjectPropertyDesc()
	{
	}

	ObjectPropertyDesc &operator=(const ObjectPropertyDesc &src);
	virtual bool operator==(const ObjectPropertyDesc &other) const;

	bool isDefaultProperty() const;
	virtual bool isConstrained() const;

private:
	template<typename Archive>
	void serialize(Archive &ar, const unsigned int version)
	{
		// If you change members here do not forget to increment object version
		// (see bottom of this file)
		ar &boost::serialization::make_nvp(
			"TableAttributeDesc",
			boost::serialization::base_object<TableAttributeDesc>(*this));
		if(version == 1)
		{
			bool isDefault;
			ar &boost::serialization::make_nvp("isDefault", isDefault);
		}
	}
};
typedef boost::shared_ptr<ObjectPropertyDesc> ObjectPropertyDescPtr;
typedef std::map<std::string, ObjectPropertyDescPtr, Utils::UpperCaseCompare>
	ObjectPropertyDescList;
typedef boost::shared_ptr<ObjectPropertyDescList> ObjectPropertyDescListPtr;
typedef std::vector<ObjectPropertyDescPtr> ObjectPropertyDescArray;
typedef boost::shared_ptr<ObjectPropertyDescArray> ObjectPropertyDescArrayPtr;
using ObjectPropertyDescListBySubFeatureKind
	= std::map<std::string, ObjectPropertyDescListPtr>;
//-----------------------------------------------------------------------------------------------------------
} // namespace ClientUtils
} // namespace GST

BOOST_CLASS_EXPORT_KEY(GST::ClientUtils::ObjectPropertyDesc);

BOOST_CLASS_VERSION(GST::ClientUtils::ObjectPropertyDesc, 2)

#endif //_OBJECTPROPERTY_DESC_H_
